#ifndef COMMON_H
#define COMMON_H

#include "MAC57D54H.h"
#include "functions.h"

typedef volatile unsigned long WORD;
typedef volatile unsigned short HALF;
typedef volatile unsigned char BYTE;

/*******************************************************************************
*  B A S I C   R E A D / W R I T E   D E F I N I T I O N S
*******************************************************************************/
//#define reg8_read(addr)       *((BYTE *)(addr))
//#define reg8_write(addr,val)  *((BYTE *)(addr)) = (val)
//#define mem8_read(addr)	reg8_read(addr)
//#define mem8_write(addr,val)	reg8_write(addr,val)

//#define reg16_read(addr)      *((HALF *)(addr))
//#define reg16_write(addr,val) *((HALF *)(addr)) = (val)
//#define mem16_read(addr)	reg16_read(addr)
//#define mem16_write(addr,val)	reg16_write(addr,val)

//#define reg32_read(addr)      *((WORD *)(addr))
//#define reg32_write(addr,val) *((WORD *)(addr)) = (val)
//#define mem32_read(addr)	reg32_read(addr)
//#define mem32_write(addr,val)	reg32_write(addr,val)


#define NULL_PTR (( void * )0)

#define var32_read(addr)      (*(uint32_t *)((addr)))
#define var8_read(addr)      (*(uint8_t *)((addr)))

#define var32_write(addr,val) (*((uint32_t *)(addr)) = (val))
#define var8_write(addr,val) (*((uint32_t *)(addr)) = (val))

#define  var32setbit(addr,bitpos) \
         var32_write((addr),(var32_read((addr)) | (1<<(bitpos))))

#define  var32clrbit(addr,bitpos) \
         var32_write((addr),(var32_read((addr)) & (0xFFFFFFFF ^ (1<<(bitpos)))))

#define  var32testbit(addr,bitpos) (((*((uint32_t *)(addr))) & (1<<(bitpos))) >> bitpos)

#endif
